// VMF settings class
local CFlags	= OOP_Derive( CHook, CCommand, CDatabase );

// constructor.
function CFlags:__ctor( )
	// hook event
	self:HookEvent( "PlayerInitialSpawn" );

	// setup the flags table.
	if( !self:TableExists( "vmfsuite_flags" ) ) then
		// create the table.
		self:Query(
			"CREATE TABLE IF NOT EXISTS vmfsuite_flags ( name VARCHAR(255), icon VARCHAR(32), superadmin INTEGER, admin INTEGER, spawnlimit INTEGER, flags VARCHAR(32), r INT, g INT, b INT );"
		);
		
		// add in the default flags.
		//
		
		// none
		self:Query(
			"INSERT INTO vmfsuite_flags ( name, icon, superadmin, admin, spawnlimit, flags, r, g, b ) VALUES( 'None', 'icons/silk/16/page', 0, 0, -1, '', -1, -1, -1 );"
		);
		
		// super admin
		self:Query(
			"INSERT INTO vmfsuite_flags ( name, icon, superadmin, admin, spawnlimit, flags, r, g, b ) VALUES( 'Super Admin', 'icons/silk/16/page_delete', 1, 0, -1, '', 128, 0, 0 );"
		);
		
		// admin
		self:Query(
			"INSERT INTO vmfsuite_flags ( name, icon, superadmin, admin, spawnlimit, flags, r, g, b ) VALUES( 'Admin', 'icons/silk/16/page_key', 1, 1, -1, '', 128, 128, 0 );"
		);
		
		// warning
		self:Query(
			"INSERT INTO vmfsuite_flags ( name, icon, superadmin, admin, spawnlimit, flags, r, g, b ) VALUES( 'Warning', 'icons/silk/16/page_error', 0, 0, 1, '', 128, 0, 0 );"
		);
	
	end
	
	
end


// Player spawned
function CFlags:OnPlayerInitialSpawn( pl )
	// read flags from the database.
	local results = self:Query(
		"SELECT * FROM vmfsuite_flags"
	);
	if( !results ) then return; end
	
	// send the flags to the client.
	local i;
	for i = 1, table.getn( results ) do
		// flag
		local flag = results[i];

		// send
		umsg.Start( "Flag", pl );
			umsg.String( flag.name );
			umsg.String( flag.icon );
			umsg.Bool( util.tobool( flag.superadmin ) );
			umsg.Bool( util.tobool( flag.admin ) );
			umsg.Short( flag.spawnlimit );
			umsg.String( flag.flags );
			umsg.Short( flag.r );
			umsg.Short( flag.g );
			umsg.Short( flag.b );
		umsg.End();
	
	end
	
end

// create.
VMFSuite.FlagSystem = CFlags:create();
